<?php
require_once '../php/includes/db.php';
require_once '../php/includes/functions.php';

requireLogin();
requireAdmin();

// Get today's game
$stmt = $pdo->prepare("SELECT * FROM games WHERE game_date = CURDATE() LIMIT 1");
$stmt->execute();
$game = $stmt->fetch();

include 'header.php';
?>

<div class="grid-2 console-layout">
    <!-- Game Control -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Consola de Sorteo</h3>
            <?php if ($game): ?>
                <span id="game-status" class="badge badge-<?php echo $game['status'] == 'active' ? 'success' : 'info'; ?>">
                    <?php echo ucfirst($game['status']); ?>
                </span>
            <?php endif; ?>
        </div>
        
        <?php if (!$game): ?>
            <div class="text-center" style="padding: 3rem;">
                <p>No hay juego programado para hoy.</p>
                <a href="games.php" class="btn btn-primary">Programar Juego</a>
            </div>
        <?php else: ?>
            <div class="text-center" style="padding: 1rem;">
                <!-- Ball Display -->
                <div class="ball-display-container">
                    <div id="last-ball" class="last-ball">
                        --
                    </div>
                    <p class="text-muted mt-2">Última Balota</p>
                </div>
                
                <!-- Controls -->
                <div class="grid-3 control-buttons">
                    <button id="btn-start" class="btn btn-success" onclick="performAction('start_game')" <?php echo $game['status'] !== 'scheduled' ? 'disabled' : ''; ?>>
                        <i class="fa-solid fa-play"></i> Iniciar
                    </button>
                    
                    <button id="btn-draw" class="btn btn-primary" onclick="performAction('draw_ball')" <?php echo $game['status'] !== 'active' ? 'disabled' : ''; ?>>
                        <i class="fa-solid fa-shuffle"></i> Sacar Balota
                    </button>
                    
                    <button id="btn-end" class="btn btn-danger" onclick="performAction('end_game')" <?php echo $game['status'] === 'finished' ? 'disabled' : ''; ?>>
                        <i class="fa-solid fa-stop"></i> Terminar
                    </button>
                </div>
                
                <div class="mt-3">
                    <label class="auto-draw-label">
                        <input type="checkbox" id="auto-draw"> 
                        <span>Sorteo Automático (Cada 5s)</span>
                    </label>
                </div>
            </div>
            
            <div class="drawn-balls-section">
                <h4>Balotas Sorteadas</h4>
                <div id="drawn-balls-container" class="drawn-balls-grid">
                    <?php 
                    $drawn = $game['drawn_numbers'] ? json_decode($game['drawn_numbers']) : [];
                    foreach ($drawn as $n) {
                        echo "<span class='ball-history'>$n</span>";
                    }
                    ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Info Panel -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Información del Juego</h3>
        </div>
        <?php if ($game): ?>
            <div class="game-info-details">
                <p><strong>ID Juego:</strong> #<?php echo $game['id']; ?></p>
                <p><strong>Premio:</strong> <?php echo formatMoney($game['prize_pool']); ?></p>
                <p><strong>Cartones Vendidos:</strong> <span id="cards-sold">...</span></p>
            </div>
            
            <h4 class="winners-title">Ganadores</h4>
            <div id="winners-list">
                <p class="text-muted">Esperando ganadores...</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    const GAME_ID = <?php echo $game ? $game['id'] : 'null'; ?>;
    let autoDrawInterval = null;

    document.getElementById('auto-draw')?.addEventListener('change', function(e) {
        if (e.target.checked) {
            autoDrawInterval = setInterval(() => {
                if (!document.getElementById('btn-draw').disabled) {
                    performAction('draw_ball');
                }
            }, 5000);
        } else {
            clearInterval(autoDrawInterval);
        }
    });

    function performAction(action) {
        if (!GAME_ID) return;
        
        const btn = document.getElementById(action === 'start_game' ? 'btn-start' : (action === 'draw_ball' ? 'btn-draw' : 'btn-end'));
        if (btn) btn.disabled = true;

        const formData = new FormData();
        formData.append('action', action);
        formData.append('game_id', GAME_ID);

        fetch('/api/admin_action.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.error) {
                alert('Error: ' + data.error);
                if (btn) btn.disabled = false;
            } else {
                // Update UI based on action
                if (action === 'start_game') {
                    location.reload();
                } else if (action === 'draw_ball') {
                    if (btn) btn.disabled = false;
                    updateBoard(data); // Assuming API returns drawn numbers, or we reload/fetch state
                    location.reload(); // Simplest for now to refresh state
                } else if (action === 'end_game') {
                    location.reload();
                }
            }
        })
        .catch(err => {
            console.error(err);
            if (btn) btn.disabled = false;
        });
    }
</script>

<?php include 'footer.php'; ?>
