<?php
require_once '../php/includes/db.php';
require_once '../php/includes/functions.php';

requireLogin();
requireAdmin();

// Handle Creation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'create_game') {
    $date = $_POST['date'];
    $price = $_POST['price'];
    $prize = $_POST['prize'];
    
    // Check if game exists for date
    $stmt = $pdo->prepare("SELECT id FROM games WHERE game_date = ?");
    $stmt->execute([$date]);
    
    if ($stmt->fetch()) {
        $_SESSION['flash_error'] = "Ya existe un juego programado para esta fecha.";
    } else {
        $stmt = $pdo->prepare("INSERT INTO games (game_date, status, card_price, prize_pool, drawn_numbers) VALUES (?, 'scheduled', ?, ?, '[]')");
        $stmt->execute([$date, $price, $prize]);
        $_SESSION['flash_message'] = "Juego programado exitosamente.";
    }
    header('Location: games.php');
    exit;
}

$stmt = $pdo->query("SELECT * FROM games ORDER BY game_date DESC");
$games = $stmt->fetchAll();

include 'header.php';
?>

<div class="grid-2">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Programar Nuevo Juego</h3>
        </div>
        <form method="POST" action="games.php">
            <input type="hidden" name="action" value="create_game">
            
            <div class="form-group">
                <label class="form-label">Fecha del Juego:</label>
                <input type="date" name="date" class="form-control" required min="<?php echo date('Y-m-d'); ?>" value="<?php echo date('Y-m-d'); ?>">
            </div>
            
            <div class="form-group">
                <label class="form-label">Precio del Cartón (COP):</label>
                <input type="number" name="price" class="form-control" required value="3000">
            </div>
            
            <div class="form-group">
                <label class="form-label">Premio Inicial (COP):</label>
                <input type="number" name="prize" class="form-control" required value="100000">
            </div>
            
            <button type="submit" class="btn btn-primary btn-block">Programar Juego</button>
        </form>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Historial de Juegos</h3>
        </div>
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Estado</th>
                        <th>Cartones</th>
                        <th>Acción</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($games as $g): ?>
                        <?php 
                            // Count cards sold
                            $stmt = $pdo->prepare("SELECT COUNT(*) FROM cards WHERE game_id = ?");
                            $stmt->execute([$g['id']]);
                            $sold = $stmt->fetchColumn();
                        ?>
                        <tr>
                            <td><?php echo date('d/m/Y', strtotime($g['game_date'])); ?></td>
                            <td>
                                <?php
                                $badgeClass = 'badge-info';
                                if ($g['status'] == 'active') $badgeClass = 'badge-success';
                                if ($g['status'] == 'finished') $badgeClass = 'badge-secondary'; // Assuming secondary for finished
                                ?>
                                <span class="badge <?php echo $badgeClass; ?>">
                                    <?php echo ucfirst($g['status']); ?>
                                </span>
                            </td>
                            <td><?php echo $sold; ?> vendidos</td>
                            <td>
                                <?php if ($g['status'] == 'active' || $g['game_date'] == date('Y-m-d')): ?>
                                    <a href="bingo_caller.php" class="btn btn-sm btn-primary"><i class="fa-solid fa-play"></i></a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
