<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CocoWin CRM - Administración</title>
    
    <!-- Fonts & Icons -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Styles -->
    <link rel="stylesheet" href="/css/style.css">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="/logo.png">
</head>
<body>
    <div class="admin-layout">
        <!-- Sidebar -->
        <aside class="admin-sidebar" id="sidebar">
            <div class="sidebar-brand">
                <img src="/logo.png" alt="CocoWin Logo" style="height: 30px; width: auto; margin-right: 10px; display: inline-block; vertical-align: middle;"> CocoWin CRM
            </div>
            
            <nav class="sidebar-menu">
                <div class="menu-category">Principal</div>
                <a href="/admin/index.php" class="menu-item <?php echo ($_SERVER['PHP_SELF'] == '/admin/index.php') ? 'active' : ''; ?>">
                    <i class="fa-solid fa-chart-line"></i> Dashboard
                </a>
                
                <div class="menu-category">Juego</div>
                <a href="/admin/games.php" class="menu-item <?php echo (strpos($_SERVER['PHP_SELF'], 'games.php') !== false) ? 'active' : ''; ?>">
                    <i class="fa-solid fa-gamepad"></i> Gestionar Juegos
                </a>
                <a href="/admin/bingo_caller.php" class="menu-item <?php echo (strpos($_SERVER['PHP_SELF'], 'bingo_caller.php') !== false) ? 'active' : ''; ?>">
                    <i class="fa-solid fa-bullhorn"></i> Cantar Bingo
                </a>
                
                <div class="menu-category">Usuarios & Finanzas</div>
                <a href="/admin/users.php" class="menu-item <?php echo (strpos($_SERVER['PHP_SELF'], 'users.php') !== false) ? 'active' : ''; ?>">
                    <i class="fa-solid fa-users"></i> Usuarios
                </a>
                <a href="/admin/transactions.php" class="menu-item <?php echo (strpos($_SERVER['PHP_SELF'], 'transactions.php') !== false) ? 'active' : ''; ?>">
                    <i class="fa-solid fa-money-bill-transfer"></i> Transacciones
                </a>
                
                <div class="menu-category">Sistema</div>
                <a href="/index.php" class="menu-item">
                    <i class="fa-solid fa-arrow-left"></i> Volver al Sitio
                </a>
                <a href="/logout.php" class="menu-item">
                    <i class="fa-solid fa-right-from-bracket"></i> Salir
                </a>
            </nav>
        </aside>

        <!-- Main Content -->
        <div class="admin-content">
            <header class="admin-header">
                <button id="sidebar-toggle" class="btn btn-outline" style="border:none; font-size:1.2rem; color:var(--text-main);">
                    <i class="fa-solid fa-bars"></i>
                </button>
                
                <div class="admin-profile" style="display: flex; align-items: center; gap: 1rem;">
                    <div class="text-right">
                        <div style="font-weight: 600;"><?php echo $_SESSION['user_name']; ?></div>
                        <div style="font-size: 0.8rem; color: var(--text-muted);">Administrador</div>
                    </div>
                    <div class="admin-avatar" style="width: 40px; height: 40px; background: var(--primary); border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold; color: var(--secondary-dark);">
                        <?php echo substr($_SESSION['user_name'], 0, 1); ?>
                    </div>
                </div>
            </header>
            
            <main style="padding: 2rem;">
                <?php if (isset($_SESSION['flash_message'])): ?>
                    <div class="card" style="background-color: #d1e7dd; color: #0f5132; border: 1px solid #badbcc; padding: 1rem; margin-bottom: 1rem;">
                        <i class="fa-solid fa-check-circle"></i> <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
                    </div>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['flash_error'])): ?>
                    <div class="card" style="background-color: #f8d7da; color: #842029; border: 1px solid #f5c2c7; padding: 1rem; margin-bottom: 1rem;">
                        <i class="fa-solid fa-triangle-exclamation"></i> <?php echo $_SESSION['flash_error']; unset($_SESSION['flash_error']); ?>
                    </div>
                <?php endif; ?>
