<?php
require_once '../php/includes/db.php';
require_once '../php/includes/functions.php';

requireLogin();
requireAdmin();

// Stats
$stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE role != 'admin'");
$total_users = $stmt->fetchColumn();

$stmt = $pdo->query("SELECT SUM(balance) FROM users");
$total_balance = $stmt->fetchColumn() ?: 0;

$stmt = $pdo->query("SELECT COUNT(*) FROM games WHERE status = 'finished'");
$games_played = $stmt->fetchColumn();

$stmt = $pdo->query("SELECT * FROM games WHERE game_date = CURDATE() LIMIT 1");
$today_game = $stmt->fetch();

include 'header.php';
?>

<div class="grid-4">
    <div class="card card-stats-primary">
        <div class="stats-content">
            <div>
                <div class="text-muted small">Usuarios Totales</div>
                <div class="stats-number"><?php echo number_format($total_users); ?></div>
            </div>
            <div class="stats-icon primary"><i class="fa-solid fa-users"></i></div>
        </div>
    </div>
    
    <div class="card card-stats-secondary">
        <div class="stats-content">
            <div>
                <div class="text-muted small">Dinero en Juego</div>
                <div class="stats-number"><?php echo formatMoney($total_balance); ?></div>
            </div>
            <div class="stats-icon secondary"><i class="fa-solid fa-wallet"></i></div>
        </div>
    </div>
    
    <div class="card card-stats-success">
        <div class="stats-content">
            <div>
                <div class="text-muted small">Juegos Realizados</div>
                <div class="stats-number"><?php echo number_format($games_played); ?></div>
            </div>
            <div class="stats-icon success"><i class="fa-solid fa-trophy"></i></div>
        </div>
    </div>
    
    <div class="card card-stats-accent">
        <div class="stats-content">
            <div>
                <div class="text-muted small">Estado Hoy</div>
                <div class="stats-number-sm">
                    <?php echo $today_game ? ucfirst($today_game['status']) : 'No Programado'; ?>
                </div>
            </div>
            <div class="stats-icon accent"><i class="fa-solid fa-calendar-day"></i></div>
        </div>
    </div>
</div>

<div class="grid-2">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Juego de Hoy</h3>
            <?php if (!$today_game): ?>
                <button class="btn btn-primary btn-sm" onclick="window.location.href='games.php'">Programar</button>
            <?php else: ?>
                <span class="badge" style="background: var(--info); padding: 5px 10px; border-radius: 4px; color: white;"><?php echo $today_game['status']; ?></span>
            <?php endif; ?>
        </div>
        
        <?php if ($today_game): ?>
            <div class="text-center" style="padding: 2rem;">
                <h1 style="font-size: 4rem; color: var(--secondary); margin: 0;">
                    <?php 
                        if ($today_game['status'] == 'active') {
                            $drawn = json_decode($today_game['drawn_numbers']) ?? [];
                            echo end($drawn) ?: '--';
                        } else {
                            echo '--';
                        }
                    ?>
                </h1>
                <p class="text-muted">Última Balota</p>
                
                <div class="mt-3">
                    <a href="bingo_caller.php" class="btn btn-success btn-block">
                        <i class="fa-solid fa-microphone"></i> Ir a la Consola de Sorteo
                    </a>
                </div>
            </div>
        <?php else: ?>
            <p class="text-center text-muted">No hay juego programado para hoy.</p>
        <?php endif; ?>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Últimos Registros</h3>
            <a href="users.php" class="btn btn-outline btn-sm">Ver Todos</a>
        </div>
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Usuario</th>
                        <th>Fecha</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $stmt = $pdo->query("SELECT name, created_at FROM users ORDER BY created_at DESC LIMIT 5");
                    while ($row = $stmt->fetch()) {
                        echo "<tr>";
                        echo "<td style='font-weight: 500;'>" . htmlspecialchars($row['name']) . "</td>";
                        echo "<td class='text-muted small'>" . date('d/m/Y', strtotime($row['created_at'])) . "</td>";
                        echo "</tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
