<?php
require_once '../php/includes/db.php';
require_once '../php/includes/functions.php';

requireLogin();
requireAdmin();

$stmt = $pdo->query("SELECT t.*, u.name as user_name, u.email as user_email FROM transactions t JOIN users u ON t.user_id = u.id ORDER BY t.created_at DESC LIMIT 50");
$transactions = $stmt->fetchAll();

include 'header.php';
?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Historial de Transacciones (Últimas 50)</h3>
    </div>
    
    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Usuario</th>
                    <th>Tipo</th>
                    <th>Descripción</th>
                    <th>Monto</th>
                    <th>Fecha</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $t): ?>
                    <tr>
                        <td>#<?php echo $t['id']; ?></td>
                        <td>
                            <div style="font-weight: 600;"><?php echo htmlspecialchars($t['user_name']); ?></div>
                            <div class="text-muted small"><?php echo htmlspecialchars($t['user_email']); ?></div>
                        </td>
                        <td>
                            <?php
                            $badgeClass = 'badge-info';
                            if ($t['type'] == 'deposit') $badgeClass = 'badge-success';
                            if ($t['type'] == 'purchase') $badgeClass = 'badge-warning';
                            if ($t['type'] == 'win') $badgeClass = 'badge-primary';
                            ?>
                            <span class="badge <?php echo $badgeClass; ?>">
                                <?php echo ucfirst($t['type']); ?>
                            </span>
                        </td>
                        <td><?php echo htmlspecialchars($t['description']); ?></td>
                        <td class="<?php echo $t['type'] == 'purchase' ? 'text-danger' : 'text-success'; ?>" style="font-weight: bold;">
                            <?php echo ($t['type'] == 'purchase' ? '-' : '+') . formatMoney($t['amount']); ?>
                        </td>
                        <td class="text-muted small"><?php echo date('d/m/Y H:i', strtotime($t['created_at'])); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'footer.php'; ?>
