<?php
require_once '../php/includes/db.php';
require_once '../php/includes/functions.php';

requireLogin();
requireAdmin();

// Handle Actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action']) && $_POST['action'] === 'add_funds') {
        $user_id = $_POST['user_id'];
        $amount = $_POST['amount'];
        
        $stmt = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
        $stmt->execute([$amount, $user_id]);
        
        $_SESSION['flash_message'] = "Fondos añadidos exitosamente.";
        header('Location: users.php');
        exit;
    }
}

// Search
$search = $_GET['search'] ?? '';
$query = "SELECT * FROM users WHERE role != 'admin'";
$params = [];

if ($search) {
    $query .= " AND (name LIKE ? OR email LIKE ? OR doc_id LIKE ?)";
    $params = ["%$search%", "%$search%", "%$search%"];
}

$query .= " ORDER BY created_at DESC";
$stmt = $pdo->prepare($query);
$stmt->execute($params);
$users = $stmt->fetchAll();

include 'header.php';
?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Gestión de Usuarios</h3>
        <form method="GET" style="display: flex; gap: 10px;">
            <input type="text" name="search" class="form-control" placeholder="Buscar usuario..." value="<?php echo htmlspecialchars($search); ?>">
            <button type="submit" class="btn btn-primary"><i class="fa-solid fa-search"></i></button>
        </form>
    </div>
    
    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nombre</th>
                    <th>Documento</th>
                    <th>Contacto</th>
                    <th>Saldo</th>
                    <th>Registro</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $u): ?>
                    <tr>
                        <td>#<?php echo $u['id']; ?></td>
                        <td>
                            <div style="font-weight: 600;"><?php echo htmlspecialchars($u['name']); ?></div>
                            <div class="text-muted small"><?php echo htmlspecialchars($u['email']); ?></div>
                        </td>
                        <td><?php echo htmlspecialchars($u['doc_id']); ?></td>
                        <td><?php echo htmlspecialchars($u['phone']); ?></td>
                        <td class="text-success font-weight-bold"><?php echo formatMoney($u['balance']); ?></td>
                        <td class="text-muted small"><?php echo date('d/m/Y', strtotime($u['created_at'])); ?></td>
                        <td>
                            <button class="btn btn-sm btn-success" onclick="openFundModal(<?php echo $u['id']; ?>, '<?php echo htmlspecialchars($u['name']); ?>')">
                                <i class="fa-solid fa-plus"></i> Saldo
                            </button>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal for adding funds -->
<div id="fundModal" class="modal-overlay">
    <div class="card modal-card">
        <div class="card-header">
            <h3 class="card-title">Recargar Saldo</h3>
            <button onclick="closeFundModal()" class="modal-close">&times;</button>
        </div>
        <form method="POST" action="users.php">
            <input type="hidden" name="action" value="add_funds">
            <input type="hidden" name="user_id" id="modal_user_id">
            
            <p>Usuario: <strong id="modal_user_name"></strong></p>
            
            <div class="form-group">
                <label class="form-label">Monto a Recargar:</label>
                <input type="number" name="amount" class="form-control" required min="1000">
            </div>
            
            <button type="submit" class="btn btn-primary btn-block">Confirmar Recarga</button>
        </form>
    </div>
</div>

<script>
    function openFundModal(id, name) {
        document.getElementById('modal_user_id').value = id;
        document.getElementById('modal_user_name').textContent = name;
        const modal = document.getElementById('fundModal');
        modal.classList.add('active');
    }
    
    function closeFundModal() {
        const modal = document.getElementById('fundModal');
        modal.classList.remove('active');
    }
</script>

<?php include 'footer.php'; ?>
