<?php
require_once '../php/includes/db.php';
require_once '../php/includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'] ?? 'Usuario';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $game_id = $_POST['game_id'] ?? 0;
    $message = trim($_POST['message'] ?? '');
    
    if ($game_id && !empty($message)) {
        $stmt = $pdo->prepare("INSERT INTO chat_messages (game_id, user_id, message) VALUES (?, ?, ?)");
        $stmt->execute([$game_id, $user_id, sanitize($message)]);
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => 'Invalid data']);
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $game_id = $_GET['game_id'] ?? 0;
    $last_id = $_GET['last_id'] ?? 0;
    
    if ($game_id) {
        $stmt = $pdo->prepare("
            SELECT cm.id, cm.message, cm.created_at, u.name as user_name 
            FROM chat_messages cm 
            JOIN users u ON cm.user_id = u.id 
            WHERE cm.game_id = ? AND cm.id > ? 
            ORDER BY cm.id ASC LIMIT 50
        ");
        $stmt->execute([$game_id, $last_id]);
        $messages = $stmt->fetchAll();
        
        echo json_encode(['messages' => $messages]);
    } else {
        echo json_encode(['error' => 'No game_id']);
    }
}
?>
