<?php
require_once '../php/includes/db.php';
require_once '../php/includes/functions.php';

header('Content-Type: application/json');

if (!isset($_GET['game_id'])) {
    echo json_encode(['error' => 'No game_id']);
    exit;
}

$game_id = (int) $_GET['game_id'];

// Fetch game
$stmt = $pdo->prepare("SELECT * FROM games WHERE id = ?");
$stmt->execute([$game_id]);
$game = $stmt->fetch();

if (!$game) {
    echo json_encode(['error' => 'Game not found']);
    exit;
}

$drawn_numbers = $game['drawn_numbers'] ? json_decode($game['drawn_numbers'], true) : [];

$winner_name = null;
if ($game['status'] === 'finished') {
    if ($game['winner_user_id']) {
        $stmt = $pdo->prepare("SELECT name FROM users WHERE id = ?");
        $stmt->execute([$game['winner_user_id']]);
        $winner_name = $stmt->fetchColumn();
    } else {
        // Machine/House won
        $winner_name = "La Banca 🤖";
    }
}

echo json_encode([
    'status' => $game['status'],
    'drawn_numbers' => $drawn_numbers,
    'winner_user_id' => $game['winner_user_id'],
    'winner_name' => $winner_name
]);
?>
