<?php
require_once 'php/includes/db.php';
require_once 'php/includes/functions.php';

requireLogin();

$user_id = $_SESSION['user_id'];

// Get available games (today or future)
$stmt = $pdo->prepare("SELECT * FROM games WHERE status = 'scheduled' AND game_date >= CURDATE() ORDER BY game_date ASC LIMIT 1");
$stmt->execute();
$game = $stmt->fetch();

if (!$game) {
    // If no game, maybe run the generator manually or show message
    $no_game = true;
} else {
    $no_game = false;
    // Get available cards for this game
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM cards WHERE game_id = ? AND user_id IS NULL");
    $stmt->execute([$game['id']]);
    $available_count = $stmt->fetchColumn();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$no_game) {
    $quantity = (int) $_POST['quantity'];
    $total_price = $quantity * 3000;
    
    // Check balance
    $stmt = $pdo->prepare("SELECT balance FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $balance = $stmt->fetchColumn();
    
    if ($balance < $total_price) {
        $_SESSION['flash_error'] = "Saldo insuficiente. Necesitas " . formatMoney($total_price);
    } elseif ($available_count < $quantity) {
        $_SESSION['flash_error'] = "Solo quedan $available_count cartones disponibles.";
    } else {
        try {
            $pdo->beginTransaction();
            
            // Deduct balance
            $stmt = $pdo->prepare("UPDATE users SET balance = balance - ? WHERE id = ?");
            $stmt->execute([$total_price, $user_id]);
            
            // Assign cards
            // Select random available cards
            $stmt = $pdo->prepare("SELECT id FROM cards WHERE game_id = ? AND user_id IS NULL LIMIT $quantity FOR UPDATE");
            $stmt->execute([$game['id']]);
            $card_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
            
            if (count($card_ids) < $quantity) {
                throw new Exception("Error de concurrencia: Cartones no disponibles.");
            }
            
            // Update cards
            $in_query = implode(',', array_fill(0, count($card_ids), '?'));
            $update_stmt = $pdo->prepare("UPDATE cards SET user_id = ?, purchased_at = NOW() WHERE id IN ($in_query)");
            $update_stmt->execute(array_merge([$user_id], $card_ids));
            
            // Log transaction
            $stmt = $pdo->prepare("INSERT INTO transactions (user_id, amount, type, description) VALUES (?, ?, 'purchase', ?)");
            $stmt->execute([$user_id, $total_price, "Compra de $quantity cartones para juego " . $game['game_date']]);
            
            $pdo->commit();
            
            $_SESSION['flash_message'] = "¡Compra exitosa! Tienes $quantity nuevos cartones.";
            header('Location: /dashboard.php');
            exit;
            
        } catch (Exception $e) {
            $pdo->rollBack();
            $_SESSION['flash_error'] = "Error en la compra: " . $e->getMessage();
        }
    }
}

include 'php/includes/header.php';
?>

<div class="grid-2">
    <!-- Game Info & Visuals -->
    <div class="card text-center">
        <div style="padding: 2rem;">
            <i class="fa-solid fa-ticket" style="font-size: 5rem; color: var(--primary); margin-bottom: 1rem; text-shadow: 0 4px 10px rgba(0,0,0,0.1);"></i>
            <h2 style="color: var(--secondary);">¡A Jugar Bingo!</h2>
            <p class="text-muted">Compra tus cartones y participa por grandes premios. Entre más cartones tengas, ¡más oportunidades de ganar!</p>
        </div>
        
        <?php if (!$no_game): ?>
        <div class="game-info-box text-left">
            <h4 style="margin-top: 0; color: var(--secondary);"><i class="fa-regular fa-calendar-check"></i> Próximo Juego</h4>
            <div style="font-size: 1.1rem; margin-bottom: 0.5rem;">
                <strong><?php echo $game['game_date']; ?></strong>
            </div>
            <div class="text-muted small">8:00 PM - Sala Principal</div>
            
            <hr style="border: 0; border-top: 1px solid rgba(0,0,0,0.1); margin: 1rem 0;">
            
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <span>Cartones Disponibles:</span>
                <span class="badge badge-success" style="font-size: 0.9rem;"><?php echo $available_count; ?></span>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Purchase Form -->
    <div class="card">
        <h3><i class="fa-solid fa-cart-shopping"></i> Comprar Cartones</h3>
        <?php if ($no_game): ?>
            <div class="alert alert-info">
                <p><i class="fa-solid fa-circle-info"></i> No hay juegos programados disponibles en este momento. Por favor intenta más tarde.</p>
            </div>
            <a href="/index.php" class="btn btn-secondary btn-block">Volver al Inicio</a>
        <?php else: ?>
            
            <form action="/buy_cards.php" method="POST" class="buy-cards-form">
                <div class="form-group">
                    <label class="form-label">Selecciona un paquete:</label>
                    <div class="package-selector">
                        <!-- Custom styled radio buttons could go here, keeping simple select for now but styled -->
                        <div style="background: var(--light); padding: 1rem; border-radius: var(--radius); border: 1px solid var(--border-color); margin-bottom: 1.5rem;">
                            <div class="text-center" style="margin-bottom: 1rem;">
                                <span style="font-size: 2rem; font-weight: bold; color: var(--secondary);">$3.000</span>
                                <span class="text-muted">/ cartón</span>
                            </div>
                            
                            <select name="quantity" id="quantity" class="form-control" style="font-size: 1.1rem; padding: 0.8rem;">
                                <option value="1">🎟️ 1 Cartón - $3.000</option>
                                <option value="2">🎟️ 2 Cartones - $6.000</option>
                                <option value="3">🎟️ 3 Cartones - $9.000</option>
                                <option value="5">🎟️ 5 Cartones - $15.000</option>
                                <option value="10">🎟️ 10 Cartones - $30.000</option>
                                <option value="20">🎟️ 20 Cartones - $60.000</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="alert alert-warning" style="font-size: 0.9rem;">
                    <i class="fa-solid fa-wallet"></i> Tu saldo actual: <strong><?php echo formatMoney($balance); ?></strong>
                </div>

                <button type="submit" class="btn btn-primary btn-block" style="font-size: 1.2rem; padding: 1rem;">
                    Confirmar Compra <i class="fa-solid fa-check-circle"></i>
                </button>
            </form>
        <?php endif; ?>
    </div>
</div>

<?php include 'php/includes/footer.php'; ?>
