<?php
// Determine the root path
$root = dirname(__DIR__);
require_once $root . '/php/includes/db.php';
require_once $root . '/php/includes/functions.php';

echo "Iniciando generación de cartones...\n";

// Target Date: Tomorrow (assuming this runs daily)
// Or we can just ensure the next 3 days exist
$target_date = date('Y-m-d'); // Ensure today exists first
$dates_to_check = [$target_date, date('Y-m-d', strtotime('+1 day'))];

foreach ($dates_to_check as $date) {
    echo "Verificando juego para fecha: $date\n";
    
    // Check if game exists
    $stmt = $pdo->prepare("SELECT id FROM games WHERE game_date = ?");
    $stmt->execute([$date]);
    $game_id = $stmt->fetchColumn();
    
    if (!$game_id) {
        echo "Creando juego para $date...\n";
        $stmt = $pdo->prepare("INSERT INTO games (game_date, status) VALUES (?, 'scheduled')");
        $stmt->execute([$date]);
        $game_id = $pdo->lastInsertId();
    } else {
        echo "Juego ya existe (ID: $game_id).\n";
    }
    
    // Check card count
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM cards WHERE game_id = ?");
    $stmt->execute([$game_id]);
    $count = $stmt->fetchColumn();
    
    if ($count < 200) {
        $needed = 200 - $count;
        echo "Generando $needed cartones para juego ID $game_id...\n";
        
        $cards_data = [];
        for ($i = 0; $i < $needed; $i++) {
            $numbers = generateBingoCardNumbers(); // Returns JSON string
            $cards_data[] = "($game_id, '$numbers', 3000.00)";
        }
        
        // Batch insert
        // Chunking to avoid query size limits
        $chunks = array_chunk($cards_data, 50);
        foreach ($chunks as $chunk) {
            $sql = "INSERT INTO cards (game_id, numbers, price) VALUES " . implode(',', $chunk);
            $pdo->query($sql);
        }
        
        echo "Cartones generados exitosamente.\n";
    } else {
        echo "Ya existen suficientes cartones para este juego.\n";
    }
}

echo "Proceso completado.\n";
?>
