<?php
require_once 'php/includes/db.php';
require_once 'php/includes/functions.php';

requireLogin();

$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

// Get recent transactions
$stmt = $pdo->prepare("SELECT * FROM transactions WHERE user_id = ? ORDER BY created_at DESC LIMIT 5");
$stmt->execute([$user_id]);
$transactions = $stmt->fetchAll();

// Get available games (rooms)
$stmt = $pdo->query("SELECT * FROM games WHERE status IN ('scheduled', 'active') ORDER BY game_date ASC");
$available_games = $stmt->fetchAll();

// Get purchased cards for upcoming games
// Assuming game logic: find active or scheduled games
$stmt = $pdo->prepare("
    SELECT c.*, g.game_date 
    FROM cards c 
    JOIN games g ON c.game_id = g.id 
    WHERE c.user_id = ? AND g.status IN ('scheduled', 'active') 
    ORDER BY g.game_date ASC
");
$stmt->execute([$user_id]);
$my_cards = $stmt->fetchAll();

include 'php/includes/header.php';
?>

<div class="card">
    <h2>Hola, <?php echo htmlspecialchars($user['name']); ?></h2>
    <p>Bienvenido a tu panel de control.</p>
    <div class="dashboard-stats">
        <div class="stat-box">
            <h3>Saldo Disponible</h3>
            <p class="stat-value text-secondary"><?php echo formatMoney($user['balance']); ?></p>
            <a href="/wallet.php" class="btn btn-primary">Recargar</a>
        </div>
        <div class="stat-box">
            <h3>Mis Cartones Activos</h3>
            <p class="stat-value"><?php echo count($my_cards); ?></p>
            <a href="/buy_cards.php" class="btn btn-success">Comprar Más</a>
        </div>
    </div>
</div>

<!-- Available Rooms Section -->
<div class="card">
    <h3><i class="fa-solid fa-door-open"></i> Salas Disponibles</h3>
    <?php if (empty($available_games)): ?>
        <p>No hay salas disponibles en este momento. ¡Vuelve pronto!</p>
    <?php else: ?>
        <div class="rooms-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(280px, 1fr)); gap: 20px; margin-top: 15px;">
            <?php foreach ($available_games as $game): ?>
                <div class="room-card" style="border: 1px solid #eee; border-radius: 10px; padding: 15px; background: linear-gradient(135deg, #f9f9f9 0%, #fff 100%); box-shadow: 0 4px 10px rgba(0,0,0,0.05); transition: transform 0.2s;">
                    <div class="room-header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                        <span class="badge badge-primary" style="font-size: 0.9rem;">Sala #<?php echo $game['id']; ?></span>
                        <span class="badge badge-<?php echo $game['status'] == 'active' ? 'success' : 'info'; ?>">
                            <?php echo $game['status'] == 'active' ? 'En Vivo' : 'Programada'; ?>
                        </span>
                    </div>
                    <h4 style="margin: 10px 0; color: #333;">Gran Bingo <?php echo formatMoney($game['prize_pool']); ?></h4>
                    <p style="color: #666; font-size: 0.9rem;">
                        <i class="fa-regular fa-clock"></i> <?php echo date('d M Y, h:i A', strtotime($game['game_date'])); ?><br>
                        <i class="fa-solid fa-ticket"></i> Valor Cartón: <?php echo formatMoney($game['card_price']); ?>
                    </p>
                    <div class="room-actions" style="margin-top: 15px;">
                        <a href="/game.php?id=<?php echo $game['id']; ?>" class="btn btn-primary btn-block">
                            <?php echo $game['status'] == 'active' ? 'Entrar a la Sala' : 'Pre-comprar Cartones'; ?>
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<div class="card">
    <h3>Mis Cartones para Próximos Juegos</h3>
    <?php if (empty($my_cards)): ?>
        <p>No tienes cartones activos. <a href="/buy_cards.php">Compra uno ahora</a>.</p>
    <?php else: ?>
        <div class="my-cards-grid">
            <?php foreach ($my_cards as $card): ?>
                <?php $nums = json_decode($card['numbers'], true); ?>
                <div class="bingo-card-mini">
                    <div class="bingo-header-mini">
                        <div>B</div><div>I</div><div>N</div><div>G</div><div>O</div>
                    </div>
                    <div class="bingo-grid-mini">
                        <?php
                        $cols = ['B', 'I', 'N', 'G', 'O'];
                        for ($row = 0; $row < 5; $row++) {
                            foreach ($cols as $col) {
                                $val = $nums[$col][$row];
                                $class = 'bingo-cell-mini';
                                if ($col == 'N' && $row == 2) {
                                    $val = '★';
                                    $class .= ' free';
                                }
                                echo "<div class='$class'>$val</div>";
                            }
                        }
                        ?>
                    </div>
                    <div class="card-footer-mini">
                        Juego: <?php echo $card['game_date']; ?> <br> ID: <?php echo $card['id']; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<div class="card">
    <h3>Últimas Transacciones</h3>
    <?php if (empty($transactions)): ?>
        <p>No hay transacciones recientes.</p>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Descripción</th>
                        <th>Tipo</th>
                        <th class="text-right">Monto</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($transactions as $txn): ?>
                        <tr>
                            <td><?php echo $txn['created_at']; ?></td>
                            <td><?php echo htmlspecialchars($txn['description']); ?></td>
                            <td><?php 
                                $type_labels = ['deposit' => 'Recarga', 'purchase' => 'Compra', 'win' => 'Premio'];
                                echo $type_labels[$txn['type']] ?? $txn['type']; 
                            ?></td>
                            <td class="text-right <?php echo $txn['type'] == 'purchase' ? 'text-danger' : 'text-success'; ?>">
                                <?php echo ($txn['type'] == 'purchase' ? '-' : '+') . formatMoney($txn['amount']); ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<?php include 'php/includes/footer.php'; ?>
