<?php
require_once 'php/includes/db.php';
require_once 'php/includes/functions.php';

requireLogin();

$user_id = $_SESSION['user_id'];

// Get today's game
$stmt = $pdo->prepare("SELECT * FROM games WHERE game_date = CURDATE() LIMIT 1");
$stmt->execute();
$game = $stmt->fetch();

$user_cards = [];
if ($game) {
    $stmt = $pdo->prepare("SELECT * FROM cards WHERE game_id = ? AND user_id = ?");
    $stmt->execute([$game['id'], $user_id]);
    $user_cards = $stmt->fetchAll();
}

include 'php/includes/header.php';
?>

<?php if (!$game): ?>
    <div class="card no-game-card">
        <i class="fa-solid fa-calendar-xmark" style="font-size: 4rem; color: var(--text-muted); margin-bottom: 1rem;"></i>
        <h2>No hay juego programado</h2>
        <p>Vuelve más tarde para disfrutar del mejor bingo online.</p>
        <a href="/index.php" class="btn btn-secondary mt-3">Volver al Inicio</a>
    </div>
<?php else: ?>

    <!-- Game Globals -->
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
    <script>
        const GAME_ID = <?php echo $game['id']; ?>;
        const CURRENT_USER_ID = <?php echo $user_id; ?>;
    </script>

    <!-- Custom Styles for Full Screen Immersion -->
    <style>
        .app-container { max-width: 100% !important; padding: 0 !important; }
        .main-content { padding: 0 !important; margin-top: 0 !important; }
        /* Hide standard footer in game mode for better immersion */
        footer { display: none; }
    </style>

    <div class="game-body">
        <div class="game-layout-3d">
            <!-- Top HUD -->
            <div class="top-hud">
                <div class="hud-left">
                    <div class="brand-badge">
                        <span class="badge" style="background: var(--primary); color: white; font-size: 0.9rem;">
                            <i class="fa-solid fa-gamepad"></i> Sala #<?php echo $game['id']; ?>
                        </span>
                    </div>
                    <div id="game-status-badge" class="badge" style="background: rgba(255,255,255,0.2); margin-top: 5px;">
                        <?php echo $game['status']; ?>
                    </div>
                </div>
                
                <div class="hud-center">
                    <!-- Spotlight Ball -->
                    <div class="spotlight-container">
                        <div class="spotlight-glow"></div>
                        <div id="current-ball" class="ball-spotlight">
                            <span class="ball-letter" style="top: 15px;">BINGO</span>
                            <span id="current-ball-num" style="margin-top: 10px;">--</span>
                        </div>
                    </div>

                    <!-- History Track -->
                    <div class="ball-track" id="ball-history">
                        <!-- History items will be injected here -->
                    </div>
                </div>

                <div class="hud-right">
                    <button id="toggle-chat-btn" class="btn btn-outline-light" style="border-radius: 50%; width: 40px; height: 40px; padding: 0;">
                        <i class="fa-solid fa-comments"></i>
                    </button>
                </div>
            </div>
            
            <!-- Mobile Chat FAB -->
            <button id="mobile-chat-fab" class="mobile-chat-fab" style="display: none;">
                <i class="fa-solid fa-comments"></i>
            </button>
            
            <!-- Main Stage -->
            <div class="game-stage">
                <!-- Cards Area -->
                <div class="stage-content">
                    <?php if (empty($user_cards)): ?>
                        <div class="text-center" style="padding: 3rem; color: white; background: rgba(0,0,0,0.3); border-radius: 20px; backdrop-filter: blur(5px);">
                            <i class="fa-regular fa-folder-open" style="font-size: 3rem; margin-bottom: 1rem;"></i>
                            <p>No tienes cartones activos.</p>
                            <a href="/buy_cards.php" class="btn btn-success mt-2" style="box-shadow: 0 5px 15px rgba(0,0,0,0.3);">Comprar Cartones</a>
                        </div>
                    <?php else: ?>
                        <?php foreach ($user_cards as $card): ?>
                            <?php $nums = json_decode($card['numbers'], true); ?>
                            <div class="bingo-card-3d" id="card-<?php echo $card['id']; ?>">
                                <div class="card-header-3d">
                                    <div class="header-letter b">B</div>
                                    <div class="header-letter i">I</div>
                                    <div class="header-letter n">N</div>
                                    <div class="header-letter g">G</div>
                                    <div class="header-letter o">O</div>
                                </div>
                                <div class="grid-3d">
                                    <?php
                                    $cols = ['B', 'I', 'N', 'G', 'O'];
                                    for ($row = 0; $row < 5; $row++) {
                                        foreach ($cols as $col) {
                                            $val = $nums[$col][$row];
                                            $class = 'cell-3d';
                                            $id = "cell-" . $card['id'] . "-" . $val;
                                            $displayVal = $val;
                                            
                                            if ($col == 'N' && $row == 2) {
                                                $val = 0; // Internal value for logic
                                                $displayVal = '<i class="fa-solid fa-star" style="color: var(--primary);"></i>';
                                                $class .= ' marked'; // Free space always marked
                                                $id = "cell-free-" . $card['id'];
                                            }
                                            echo "<div class='$class' id='$id'>$displayVal</div>";
                                        }
                                    }
                                    ?>
                                </div>
                                <div style="margin-top: 10px; text-align: center; font-size: 0.8rem; color: #666; font-weight: 600;">
                                    Cartón #<?php echo $card['id']; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                
                <!-- Chat Sidebar -->
                <div class="sidebar-panel" id="chat-sidebar">
                    <div class="sidebar-header">
                        <span><i class="fa-solid fa-comments"></i> Chat de Sala</span>
                        <button id="close-chat" style="background:none; border:none; color:white; cursor:pointer;"><i class="fa-solid fa-times"></i></button>
                    </div>
                    
                    <div class="sidebar-content chat-messages" id="chat-messages" style="background: #f8f9fa;">
                        <div style="text-align: center; color: var(--text-muted); font-size: 0.9rem; padding: 1rem;">
                            Bienvenido al chat. ¡Sé amable y diviértete!
                        </div>
                    </div>
                    
                    <div style="padding: 15px; background: white; border-top: 1px solid #ddd;">
                        <div class="input-group">
                            <input type="text" id="chat-input" class="form-control" placeholder="Escribe aquí..." style="border-radius: 20px 0 0 20px;">
                            <button id="btn-send-chat" class="btn btn-primary" style="border-radius: 0 20px 20px 0;">
                                <i class="fa-solid fa-paper-plane"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Win Modal -->
    <div id="win-modal" class="win-modal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.8); z-index:1000; align-items:center; justify-content:center; flex-direction:column; color:white;">
        <h1 class="win-modal-title" style="font-size: 4rem; color: #ffd700; text-shadow: 0 0 20px #ff6b6b; animation: bounceIn 1s;">¡BINGO!</h1>
        <p class="win-modal-text" style="font-size: 1.5rem; margin: 1rem 0;">¡Tenemos un ganador!</p>
        <button class="btn btn-outline-light" style="margin-top: 2rem; border-radius: 50px; padding: 10px 30px;" onclick="document.getElementById('win-modal').style.display = 'none'">Seguir viendo</button>
    </div>

<?php endif; ?>

<script>
    const GAME_ID = <?php echo $game ? $game['id'] : 'null'; ?>;
</script>
<script src="/js/game.js"></script>

<?php include 'php/includes/footer.php'; ?>
