<?php
require_once 'php/includes/db.php';
require_once 'php/includes/functions.php';

if (isLoggedIn()) {
    header('Location: /dashboard.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = sanitize($_POST['email']);
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_name'] = $user['name'];
        $_SESSION['role'] = $user['role'];
        
        header('Location: /dashboard.php');
        exit;
    } else {
        $_SESSION['flash_error'] = "Credenciales incorrectas.";
    }
}

include 'php/includes/header.php';
?>

<div class="card auth-container">
    <div class="card-header text-center" style="justify-content: center; border-bottom: none;">
        <h2 class="card-title" style="font-size: 1.8rem;">Bienvenido</h2>
    </div>
    <form action="/login.php" method="POST">
        <div class="form-group">
            <label class="form-label" for="email">Correo Electrónico:</label>
            <div class="input-group">
                <span class="input-prefix"><i class="fa-solid fa-envelope"></i></span>
                <input class="form-control" type="email" id="email" name="email" required placeholder="tu@email.com">
            </div>
        </div>
        <div class="form-group">
            <label class="form-label" for="password">Contraseña:</label>
            <div class="input-group">
                <span class="input-prefix"><i class="fa-solid fa-lock"></i></span>
                <input class="form-control" type="password" id="password" name="password" required placeholder="••••••••">
            </div>
        </div>
        <button type="submit" class="btn btn-primary btn-block mt-3">
            Ingresar <i class="fa-solid fa-arrow-right"></i>
        </button>
    </form>
    <div class="text-center mt-3 small">
        ¿No tienes cuenta? <a href="/register.php" class="text-secondary font-weight-bold">Regístrate aquí</a>
    </div>
</div>

<?php include 'php/includes/footer.php'; ?>
