<?php
function formatMoney($amount) {
    return '$' . number_format($amount, 0, ',', '.') . ' COP';
}

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: /login.php');
        exit;
    }
}

function isAdmin() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
}

function requireAdmin() {
    if (!isAdmin()) {
        header('Location: /index.php');
        exit;
    }
}

function sanitize($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

// Generate Bingo Card Numbers
function generateBingoCardNumbers() {
    $card = [
        'B' => [], 'I' => [], 'N' => [], 'G' => [], 'O' => []
    ];
    
    // B: 1-15
    $numbers = range(1, 15);
    shuffle($numbers);
    $card['B'] = array_slice($numbers, 0, 5);
    
    // I: 16-30
    $numbers = range(16, 30);
    shuffle($numbers);
    $card['I'] = array_slice($numbers, 0, 5);
    
    // N: 31-45 (center is free, handled in UI usually, but we store 5 nums and ignore center logic in storage or mark it)
    // Traditionally N has 4 numbers and a free space. Let's store 5 numbers but the 3rd one is the "free" one or just store 4.
    // To keep it simple in JSON, we'll store 5 numbers, and the middle one (index 2) will be 0 or handled as free.
    $numbers = range(31, 45);
    shuffle($numbers);
    $slice = array_slice($numbers, 0, 5);
    $slice[2] = 0; // 0 represents FREE space
    $card['N'] = $slice;
    
    // G: 46-60
    $numbers = range(46, 60);
    shuffle($numbers);
    $card['G'] = array_slice($numbers, 0, 5);
    
    // O: 61-75
    $numbers = range(61, 75);
    shuffle($numbers);
    $card['O'] = array_slice($numbers, 0, 5);
    
    return json_encode($card);
}
?>
