<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>CocoWin - Tu Bingo Colombiano</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Styles -->
    <link rel="stylesheet" href="/css/style.css">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="/logo.png">
</head>
<body>
    <div class="app-container">
        <header class="main-header">
            <a href="/index.php" class="logo-area">
                <img src="/logo.png" alt="CocoWin Logo" style="height: 50px; width: auto;">
                <span>CocoWin</span>
            </a>
            
            <button class="mobile-menu-toggle" id="mobile-menu-btn">
                <i class="fa-solid fa-bars"></i>
            </button>
            
            <nav>
                <div class="nav-links" id="nav-links">
                    <a href="/index.php" class="nav-item <?php echo ($_SERVER['PHP_SELF'] == '/index.php') ? 'active' : ''; ?>">
                        <i class="fa-solid fa-house"></i> Inicio
                    </a>
                    
                    <?php if (isLoggedIn()): ?>
                        <a href="/dashboard.php" class="nav-item <?php echo ($_SERVER['PHP_SELF'] == '/dashboard.php') ? 'active' : ''; ?>">
                            <i class="fa-solid fa-user"></i> Mi Cuenta
                        </a>
                        <a href="/game.php" class="nav-item <?php echo ($_SERVER['PHP_SELF'] == '/game.php') ? 'active' : ''; ?>">
                            <i class="fa-solid fa-gamepad"></i> Jugar
                        </a>
                        <a href="/wallet.php" class="nav-item <?php echo ($_SERVER['PHP_SELF'] == '/wallet.php') ? 'active' : ''; ?>">
                            <i class="fa-solid fa-wallet"></i> Billetera
                        </a>
                        <?php if (isAdmin()): ?>
                            <a href="/admin/index.php" class="nav-item" style="color: var(--primary);">
                                <i class="fa-solid fa-lock"></i> Admin CRM
                            </a>
                        <?php endif; ?>
                        <a href="/logout.php" class="nav-item">
                            <i class="fa-solid fa-right-from-bracket"></i> Salir
                        </a>
                    <?php else: ?>
                        <div class="auth-buttons">
                            <a href="/login.php" class="btn btn-outline" style="color:white; border-color:white;">Ingresar</a>
                            <a href="/register.php" class="btn btn-primary">Registro</a>
                        </div>
                    <?php endif; ?>
                </div>
            </nav>
        </header>

        <main class="main-content">
            <?php if (isset($_SESSION['flash_message'])): ?>
                <div class="card" style="background-color: #d1e7dd; color: #0f5132; border: 1px solid #badbcc; padding: 1rem; margin-bottom: 1rem;">
                    <i class="fa-solid fa-check-circle"></i> <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($_SESSION['flash_error'])): ?>
                <div class="card" style="background-color: #f8d7da; color: #842029; border: 1px solid #f5c2c7; padding: 1rem; margin-bottom: 1rem;">
                    <i class="fa-solid fa-triangle-exclamation"></i> <?php echo $_SESSION['flash_error']; unset($_SESSION['flash_error']); ?>
                </div>
            <?php endif; ?>
