<?php
require_once 'php/includes/db.php';
require_once 'php/includes/functions.php';

if (isLoggedIn()) {
    header('Location: /dashboard.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = sanitize($_POST['name']);
    $email = sanitize($_POST['email']);
    $password = $_POST['password'];
    $doc_id = sanitize($_POST['doc_id']);
    $phone = sanitize($_POST['phone']);

    // Basic Validation
    if (empty($name) || empty($email) || empty($password) || empty($doc_id)) {
        $_SESSION['flash_error'] = "Todos los campos obligatorios deben ser llenados.";
    } else {
        // Hash password
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        try {
            $pdo->beginTransaction();

            // Insert user with 10,000 welcome bonus
            $stmt = $pdo->prepare("INSERT INTO users (name, email, password, doc_id, phone, address, balance) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$name, $email, $hashed_password, $doc_id, $phone, "", 10000]);
            
            $user_id = $pdo->lastInsertId();

            // Log the welcome bonus transaction
            $stmt = $pdo->prepare("INSERT INTO transactions (user_id, amount, type, description) VALUES (?, ?, 'deposit', 'Bono de Bienvenida')");
            $stmt->execute([$user_id, 10000]);

            $pdo->commit();
            
            $_SESSION['flash_message'] = "Registro exitoso. ¡Has recibido un bono de $10.000! Por favor inicia sesión.";
            header('Location: /login.php');
            exit;
        } catch (PDOException $e) {
            $pdo->rollBack();
            if ($e->getCode() == 23000) { // Duplicate entry
                $_SESSION['flash_error'] = "El correo electrónico o documento de identidad ya está registrado.";
            } else {
                $_SESSION['flash_error'] = "Error en el registro: " . $e->getMessage();
            }
        }
    }
}

include 'php/includes/header.php';
?>

<div class="card auth-container-lg">
    <div class="card-header text-center" style="justify-content: center; border-bottom: none;">
        <h2 class="card-title" style="font-size: 1.8rem;">Crear Cuenta</h2>
    </div>
    <form action="/register.php" method="POST">
        <div class="form-group">
            <label class="form-label" for="name">Nombre Completo:</label>
            <input class="form-control" type="text" id="name" name="name" required placeholder="Tu Nombre">
        </div>
        <div class="form-group">
            <label class="form-label" for="email">Correo Electrónico:</label>
            <input class="form-control" type="email" id="email" name="email" required placeholder="tu@email.com">
        </div>
        <div class="form-group">
            <label class="form-label" for="password">Contraseña:</label>
            <input class="form-control" type="password" id="password" name="password" required placeholder="Crea una contraseña segura">
        </div>
        <div class="grid-2" style="gap: 1rem;">
            <div class="form-group">
                <label class="form-label" for="doc_id">Cédula / ID:</label>
                <input class="form-control" type="text" id="doc_id" name="doc_id" required placeholder="123456789">
            </div>
            <div class="form-group">
                <label class="form-label" for="phone">Teléfono:</label>
                <input class="form-control" type="text" id="phone" name="phone" placeholder="300 123 4567">
            </div>
        </div>
        
        <button type="submit" class="btn btn-primary btn-block mt-3">
            Registrarse <i class="fa-solid fa-user-plus"></i>
        </button>
    </form>
    <div class="text-center mt-3 small">
        ¿Ya tienes cuenta? <a href="/login.php" class="text-secondary font-weight-bold">Inicia Sesión</a>
    </div>
</div>

<?php include 'php/includes/footer.php'; ?>
