<?php
require_once 'php/includes/db.php';
require_once 'php/includes/functions.php';

requireLogin();

$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT balance FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$balance = $stmt->fetchColumn();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['amount'])) {
    $amount = (float) $_POST['amount'];
    
    if ($amount < 10000) {
        $_SESSION['flash_error'] = "El monto mínimo de recarga es $10.000 COP.";
    } else {
        // Simulate Payment Process
        // In a real app, here we would redirect to PSE/Payment Gateway
        // For now, we instantly credit
        
        try {
            $pdo->beginTransaction();
            
            // Update balance
            $stmt = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
            $stmt->execute([$amount, $user_id]);
            
            // Log transaction
            $stmt = $pdo->prepare("INSERT INTO transactions (user_id, amount, type, description) VALUES (?, ?, 'deposit', 'Recarga de Saldo (Simulado PSE)')");
            $stmt->execute([$user_id, $amount]);
            
            $pdo->commit();
            
            $_SESSION['flash_message'] = "Recarga exitosa de " . formatMoney($amount);
            header('Location: /wallet.php');
            exit;
        } catch (Exception $e) {
            $pdo->rollBack();
            $_SESSION['flash_error'] = "Error procesando la recarga.";
        }
    }
}

include 'php/includes/header.php';
?>

<div class="card" style="max-width: 600px; margin: 0 auto;">
    <div class="text-center" style="margin-bottom: 2rem;">
        <h2 style="color: var(--secondary); margin-bottom: 1.5rem;">Mi Billetera</h2>
        <div style="background: linear-gradient(135deg, var(--primary) 0%, #ffd700 100%); color: var(--secondary-dark); padding: 2rem; border-radius: var(--radius); display: block; box-shadow: 0 10px 20px rgba(252, 209, 22, 0.3); position: relative; overflow: hidden;">
            <i class="fa-solid fa-wallet" style="position: absolute; right: -20px; bottom: -20px; font-size: 8rem; opacity: 0.2;"></i>
            <div style="font-size: 0.9rem; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 0.5rem; position: relative;">Saldo Disponible</div>
            <div style="font-size: 3rem; font-weight: 800; line-height: 1; position: relative;"><?php echo formatMoney($balance); ?></div>
        </div>
    </div>
    
    <div class="wallet-section">
        <h3 style="border-bottom: 1px solid var(--border-color); padding-bottom: 1rem; margin-bottom: 1.5rem; color: var(--secondary);">
            <i class="fa-solid fa-circle-plus text-success"></i> Recargar Saldo
        </h3>
        <p class="text-muted mb-2">Selecciona un método de pago seguro para recargar tu cuenta.</p>
        
        <form action="/wallet.php" method="POST" class="wallet-form">
            <div class="form-group">
                <label class="form-label" for="amount">Monto a Recargar:</label>
                <div class="input-group">
                    <span class="input-prefix" style="font-weight: bold; color: var(--success);">$</span>
                    <input type="number" id="amount" name="amount" min="10000" step="1000" value="10000" class="form-control" style="font-size: 1.2rem; font-weight: bold;" required>
                </div>
                <div class="text-muted small mt-1"><i class="fa-solid fa-circle-info"></i> Mínimo $10.000 COP</div>
            </div>
            
            <div class="form-group">
                <label class="form-label">Método de Pago:</label>
                <div class="payment-methods">
                    <label class="payment-method">
                        <input type="radio" name="method" value="pse" checked> 
                        <div style="font-size: 1.5rem; margin: 0.5rem 0;"><i class="fa-solid fa-building-columns"></i></div>
                        <span style="font-weight: 600;">PSE</span>
                    </label>
                    <label class="payment-method">
                        <input type="radio" name="method" value="bancolombia"> 
                        <div style="font-size: 1.5rem; margin: 0.5rem 0;"><i class="fa-solid fa-qrcode"></i></div>
                        <span style="font-weight: 600;">Bancolombia</span>
                    </label>
                    <label class="payment-method">
                        <input type="radio" name="method" value="nequi"> 
                        <div style="font-size: 1.5rem; margin: 0.5rem 0;"><i class="fa-solid fa-mobile-screen"></i></div>
                        <span style="font-weight: 600;">Nequi</span>
                    </label>
                </div>
            </div>
            
            <button type="submit" class="btn btn-success btn-block" style="padding: 1rem; font-size: 1.1rem;">
                Pagar y Recargar <i class="fa-solid fa-lock" style="margin-left: 0.5rem; font-size: 0.9rem;"></i>
            </button>
            <div class="text-center mt-3">
                <p class="text-muted small" style="background: #f8f9fa; padding: 0.5rem; border-radius: 4px;">
                    <i class="fa-solid fa-shield-halved"></i> Transacción segura y encriptada.
                    <br><span style="color: var(--accent);">* Simulación: No se realizará cargo real.</span>
                </p>
            </div>
        </form>
    </div>
</div>

<?php include 'php/includes/footer.php'; ?>
